;
;****************************************************************************
;
;  Purpose:
;	Calculate CRC-8 Values.  Uses The CCITT-8 Polynomial, Expressed As
;	X^8 + X^5 + X^4 + 1
;
;  Date:
;	08/03/93
;
;  Author:
;	John C. Wren
;
;  Modications:
;	02/04/97 - Added Description Fields For Archive
;
;  Processor:
;	Generic 8031
;
;  Assembler:
;	Avocet AVA51
;
;  Dependencies:
;	None
;
;  Files:
;	None
;
;  Philosophic:
; 
;****************************************************************************
;
;  Includes
;
;		%include "equates.inc"
		seg	code
;
;****************************************************************************
;
;  Publics
;
		public	CRC8_ADD_B
;
;****************************************************************************
;
;  Description:
;	Calculates Value In Acc Into The Running CRC In 'B'
;
;  Entry Requirements:
;	Acc Has Value To Add To CRC
;	'B' Contains Running CRC Value
;
;  On Exit:
;	'B' Has Updated CRC Value
;
;  Affected:
;	PSW.CY, B
;
;  Stack:
;	0 Bytes, Not Including Called Routines
;
;  Comments:
;	Depending On Whether Space Or Speed Is Needed, Point This Jump To
;	Code Needed And Comment Out The Other Block.  This Allows A Standard
;	Entry Point To Be Used.
;
CRC8_ADD_B	proc
		jmp	CRC8_ADD_CALC		; Use Fast Method
		endproc
;
;****************************************************************************
;
;  Description:
;	Calculates Value In Acc Into The Running CRC In 'B', Using The Table
;	Method.  (Faster But Larger)
;
;  Entry Requirements:
;	Acc Has Value To Add To CRC
;	'B' Contains Running CRC Value
;
;  On Exit:
;	'B' Has Updated CRC Value
;
;  Affected:
;	PSW.CY, B
;
;  Stack:
;	3 Bytes, Not Including Called Routines
;
;  Comments:
;	None
;
CRC8_ADD_TABLE	proc
		push	dph			; Save DPH
		push	dpl			; Save DPL
		push	acc			; Save Acc
;
		mov	dptr,#CRC8_DATA		; Point To Table
		xrl	a,b			; XOR In CRC
		movc	a,@a+dptr		; Get New CRC Byte
		mov	b,a			; Store Back
;
		pop	acc			; Recover Acc
		pop	dpl			; Recover DPL
		pop	dph			; Recover DPH
		ret				; Return To Caller
		endproc
;
;****************************************************************************
;
;  Description:
;	Calculates Value In Acc Into The Running CRC In 'B', Using The 
;	Calculation Method (Slower But Smaller).
;
;  Entry Requirements:
;	Acc Has Value To Add To CRC
;	'B' Contains Running CRC Value
;
;  On Exit:
;	'B' Has Updated CRC Value
;
;  Affected:
;	PSW.CY, B
;
;  Stack:
;	3 Bytes, Not Including Called Routines
;
;  Comments:
;	None
;
CRC8_ADD_CALC	proc
		push	acc			; Save Acc
		push	0			; Save R0
		push	acc			; Save Value
		mov	r0,#8			; Number Bits In Byte
;
l?p1		xrl	a,b			; Calculate CRC
		rrc	a			; Move To Carry
		mov	a,b			; Get The Last CRC Value
		jnc	l?p2			; Skip If Data == 0
		xrl	a,#18h			; Update The CRC Value
;
l?p2		rrc	a			; Position The New CRC
		mov	b,a			; Store The New CRC
		pop	acc			; Get The Remaining Bits
		rr	a			; Position The Next Bit
		push	acc			; Save The Remaining Bits
		djnz	r0,l?p1			; Repeat For 8 Bits
;
		pop	acc			; Clean Up Stack
		pop	0			; Recover R0
		pop	acc			; Recover Acc
		ret				; Return To Caller
		endproc
;
;****************************************************************************
;
;  Data For Table Method
;
CRC8_DATA	db	000h, 05eh, 0bch, 0e2h, 061h, 03fh, 0ddh, 083h
		db	0c2h, 09ch, 07eh, 020h, 0a3h, 0fdh, 01fh, 041h
		db	09dh, 0c3h, 021h, 07fh, 0fch, 0a2h, 040h, 01eh
		db	05fh, 001h, 0e3h, 0bdh, 03eh, 060h, 082h, 0dch
		db	023h, 07dh, 09fh, 0c1h, 042h, 01ch, 0feh, 0a0h
		db	0e1h, 0bfh, 05dh, 003h, 080h, 0deh, 03ch, 062h
		db	0beh, 0e0h, 002h, 05ch, 0dfh, 081h, 063h, 03dh
		db	07ch, 022h, 0c0h, 09eh, 01dh, 043h, 0a1h, 0ffh
		db	046h, 018h, 0fah, 0a4h, 027h, 079h, 09bh, 0c5h
		db	084h, 0dah, 038h, 066h, 0e5h, 0bbh, 059h, 007h
		db	0dbh, 085h, 067h, 039h, 0bah, 0e4h, 006h, 058h
		db	019h, 047h, 0a5h, 0fbh, 078h, 026h, 0c4h, 09ah
		db	065h, 03bh, 0d9h, 087h, 004h, 05ah, 0b8h, 0e6h
		db	0a7h, 0f9h, 01bh, 045h, 0c6h, 098h, 07ah, 024h
		db	0f8h, 0a6h, 044h, 01ah, 099h, 0c7h, 025h, 07bh
		db	03ah, 064h, 086h, 0d8h, 05bh, 005h, 0e7h, 0b9h
		db	08ch, 0d2h, 030h, 06eh, 0edh, 0b3h, 051h, 00fh
		db	04eh, 010h, 0f2h, 0ach, 02fh, 071h, 093h, 0cdh
		db	011h, 04fh, 0adh, 0f3h, 070h, 02eh, 0cch, 092h
		db	0d3h, 08dh, 06fh, 031h, 0b2h, 0ech, 00eh, 050h
		db	0afh, 0f1h, 013h, 04dh, 0ceh, 090h, 072h, 02ch
		db	06dh, 033h, 0d1h, 08fh, 00ch, 052h, 0b0h, 0eeh
		db	032h, 06ch, 08eh, 0d0h, 053h, 00dh, 0efh, 0b1h
		db	0f0h, 0aeh, 04ch, 012h, 091h, 0cfh, 02dh, 073h
		db	0cah, 094h, 076h, 028h, 0abh, 0f5h, 017h, 049h
		db	008h, 056h, 0b4h, 0eah, 069h, 037h, 0d5h, 08bh
		db	057h, 009h, 0ebh, 0b5h, 036h, 068h, 08ah, 0d4h
		db	095h, 0cbh, 029h, 077h, 0f4h, 0aah, 048h, 016h
		db	0e9h, 0b7h, 055h, 00bh, 088h, 0d6h, 034h, 06ah
		db	02bh, 075h, 097h, 0c9h, 04ah, 014h, 0f6h, 0a8h
		db	074h, 02ah, 0c8h, 096h, 015h, 04bh, 0a9h, 0f7h
		db	0b6h, 0e8h, 00ah, 054h, 0d7h, 089h, 06bh, 035h
;
;****************************************************************************
;
		end
